/* JavaScript fr Seiten */

// Name der aktuellen html Datei
var filename = self.location.pathname;
filename = filename.substring(filename.lastIndexOf('/') + 1);

// Frameset nachladen
if (top.location == self.location) {
    top.location.href = 'index.html?' + filename + self.location.hash;
}

/**
 * Whlt die aktuelle Datei im Inhaltsverzeichnis aus.
 */
function setContentSelection() {
    top.navbody.setContentSelection(filename + self.location.hash);
}

/**
 * Wertet die in der URL bergebenen Suchwrter aus und markiert die
 * Trefferstellen in der Seite.
 */
function highlightSearch() {
    if (self.location.search) {
        // Suchwrter aus Parametern ermitteln
        var search = self.location.search.substring(1);
        var exps = search.split('&');

        // Regulrer Ausdruck fr Zeichen das nicht zu einem Wort gehhren
        // und daher eine Wortgrenze darstellen.
        // Aktuell sind hier neben Whitespaces (RegExp Zeichenklasse \s) die
        // folgenden Zeichen kodiert: ^!"$%&/(){}[]=?*+'#<>|,.-;:_
        var wordsReg = new RegExp('[\\s\\'
                + '^\\!"\\$%&\\/\\(\\)\\{\\}\\[\\]=?\\\\'
                + '\\*\\+\'#<>\\|,\\.\\-;:_]+', '');

        // Suchwrter markieren
        for (var idx = 0; idx < exps.length; ++idx) {
            var searchReg = new RegExp('^' + unescape(exps[idx]) + '$', 'i');
            _doHighlightSearch(
                    document.getElementById('content'),
                    wordsReg, searchReg);
        }
    }
}

/**
 * Traversiert den DOM Baum mit dem gegebenen Wurzelknoten rekursiv und
 * fhrt fr jeden Textknoten die Worthervorhebung aus.
 *
 * @param node der DOM Knoten
 * @param wordsReg der regulre Ausdruck fr Wortgrenzen (RegExp)
 * @param searchReg der regulre Ausdruck fr das Suchwort (RegExp)
 */
function _doHighlightSearch(node, wordsReg, searchReg) {
    for (var idx = 0; idx < node.childNodes.length; ++idx) {
        var child = node.childNodes[idx];
        if (child.nodeType == 3) { // TEXT_NODE
            // Suchwrter hervorheben
            // dabei wird node.childNodes verndert
            idx += _doHighlightWords(node, child, wordsReg, searchReg);
        } else if ((child.nodeType == 1) // ELEMENT_NODE
                && (child.tagName == 'span')
                && (child.className == 'highlight')) {
            // der Knoten ist bereits eine Hervorhebung
            // noop
        } else {
            // rekursiv abarbeiten
            _doHighlightSearch(child, wordsReg, searchReg);
        }
        
    }
}

/**
 * Fhrt die Markierung im Text des gegebenen DOM Textknotens mit dem
 * gegebenen regulre Ausdruck aus.
 *
 * @param parent der bergeordnete DOM Knoten
 * @param node der DOM Textknoten (nodeType == 3)
 * @param wordsReg der regulre Ausdruck fr Wortgrenzen (RegExp)
 * @param searchReg der regulre Ausdruck fr das Suchwort (RegExp)
 * @return die Anzahl zustzlich erzeugter Kinder im bergeordneten DOM Knoten
 */
function _doHighlightWords(parent, node, wordsReg, searchReg) {
    var res = 0;

    // nach Wortgrenzen suchen
    var text = node.nodeValue;
    //alert('Knoten: _' + text + '_');
    var textBefore = '';
    var wordsMatch = wordsReg.exec(text);
    while (wordsMatch != null) {
        var idx = wordsMatch.index;
        var len = wordsMatch.toString().length;
        
        // Text vor der Wortgrenze auswerten
        var txt = text.substring(0, idx);
        if (searchReg.test(txt)) {
            // Text vor dem Treffer ausgeben
            if (textBefore.length > 0) {
                //alert('Txt: _' + textBefore + '_');
                parent.insertBefore(
                        document.createTextNode(textBefore), node);
                ++res;
                textBefore = '';
            }
            // Treffer mit Hervorhebung ausgeben
            //alert('Hit: _' + txt + '_');
            var eHighlight = document.createElement('span');
            eHighlight.className = 'highlight';
            eHighlight.appendChild(document.createTextNode(txt));
            parent.insertBefore(eHighlight, node);
            ++res;
        } else {
            // sonstigen Text sammeln
            textBefore += txt;
        }

        // Wortgrenze als sonstigen Text sammeln
        textBefore += wordsMatch.toString();
    
        // weiter suchen
        text = text.substring(idx + len);
        wordsMatch = wordsReg.exec(text);
    }
    
    // restlichen Text auswerten
    if (text.length > 0) {
        if (searchReg.test(text)) {
            // Text vor dem Treffer ausgeben
            if (textBefore.length > 0) {
                //alert('Txt: _' + textBefore + '_');
                parent.insertBefore(
                        document.createTextNode(textBefore), node);
                ++res;
                textBefore = '';
            }
            // Treffer mit Hervorhebung ausgeben
            //alert('Hit: _' + text + '_');
            var eHighlight = document.createElement('span');
            eHighlight.className = 'highlight';
            eHighlight.appendChild(document.createTextNode(text));
            parent.insertBefore(eHighlight, node);
            ++res;
        } else {
            // sonstigen Text sammeln
            textBefore += text;
        }
    }

    // Text nach dem letzten Treffer in den alten Textknoten setzen
    if (textBefore.length > 0) {
        //alert('Txt: _' + textBefore + '_');
        node.nodeValue = textBefore;
        textBefore = '';
    } else {
        // alten Textknoten entfernen
        parent.removeChild(node);
    }
    
    return res;
}
